#include "StdAfx.h"
#include "Res.h"


CRes::CRes()
{
}

CRes::~CRes(void)
{
	//Close();
}

void CRes::Close()
{
	CFileFlow::Close();
	memset( &hdr, 0, sizeof(hdr) );
	entries.clear();
	files_names.clear();
}

BOOL CRes::OpenRead( LPCSTR lpszFilePath )
{
	if ( CFileFlow::OpenRead( lpszFilePath ) )
		return ReadHash();

	return FALSE;
}

BOOL CRes::ReadHash()
{
	Read( &hdr, sizeof(hdr) );
	if ( hdr.dwSignature != SIGNATURE )
		return error( "CRes::OpenRead()\nWrong file format : %s!", GetFileName() );

	SetPosition( hdr.dwOffsetTable );
	entries.resize( hdr.dwFilesCount );
	Read( &entries.front(),sizeof(HashEntry) * hdr.dwFilesCount );

	char *lpszNames = new char[hdr.dwSizeNameTable + 1];
	Read( lpszNames, hdr.dwSizeNameTable );
	lpszNames[hdr.dwSizeNameTable] = '\0';
	_strlwr_s( lpszNames, hdr.dwSizeNameTable + 1 );
	files_names.resize( hdr.dwSizeNameTable );
	memcpy( &files_names.front(), lpszNames, hdr.dwSizeNameTable );
	delete [] lpszNames;
	return TRUE;
}
BOOL CRes::GetFile( LPCSTR lpszFileName, IFlow &file )
{
	char szFileName[_MAX_FNAME];
	strcpy_s( szFileName, lpszFileName );
	_strlwr_s( szFileName, _MAX_FNAME );

	int nIndex(0);
	if ( !FindFile( szFileName, nIndex ) )
		return FALSE;

	const void *lpFile = SetPosition( entries[nIndex].dwFileOffset );
	DWORD dwSize = entries[nIndex].dwFileSize;
	file.Attach( lpFile, dwSize );
	if ( file.IsRes() )
		file.ReadHash();
	return TRUE;
}

BOOL CRes::FindFile( LPCSTR lpszFileName, int &nIndex ) const
{
	int nSize = (int)strlen( lpszFileName );
	nIndex = CalcHash( lpszFileName, nSize );

	//const char *pszName = &files_names[entries[dwIndex].dwNameOffset];
	while ( nSize != entries[nIndex].wNameSize || strncmp( lpszFileName, &files_names[entries[nIndex].dwNameOffset], nSize ) )
	//while ( nSize != entries[nIndex].wNameSize || _strnicmp( lpszFileName, &files_names[entries[nIndex].dwNameOffset], nSize ) != 0 )
	{
		nIndex = entries[nIndex].dwNextIndex;
		if ( nIndex == -1 )
			return FALSE;
	}
	return TRUE;
}
int CRes::CalcHash( LPCSTR lpszFileName, int nSize ) const
{
	int hash(0);
	while ( nSize-- )
		hash += lpszFileName[nSize];

	return hash % hdr.dwFilesCount;
}

// for write res
BOOL CRes::OpenWrite( LPCSTR lpszFilePath )
{
	if ( !CFileFlow::OpenWrite( lpszFilePath ) )
		return FALSE;

	hdr.dwSignature = SIGNATURE;
	hdr.dwFilesCount = 0;
	hdr.dwOffsetTable = sizeof(FileHeader);
	hdr.dwSizeNameTable = 0;
	//     
	CFlow::Write( &hdr, sizeof( FileHeader ) );
	return TRUE;
}
void CRes::AddFile( LPCSTR lpszFileName, LPCVOID lpData, DWORD dwSize )
{
	HashEntry entry;
	entry.dwFileOffset = hdr.dwOffsetTable;
	entry.dwFileSize = dwSize;
	entry.dwNameOffset = (DWORD)files_names.size();
	entry.dwNextIndex = -1;
	entry.utime = 0;
	entry.wNameSize = (WORD)strlen(lpszFileName);

	hdr.dwFilesCount++;
	hdr.dwOffsetTable += dwSize;
	hdr.dwSizeNameTable += entry.wNameSize;


	char szFileName[_MAX_FNAME];
	strcpy_s( szFileName, lpszFileName );
	_strlwr_s( szFileName, strlen(szFileName) + 1 );

	files_names.insert( files_names.end(), &szFileName[0], &szFileName[entry.wNameSize] );
	entries.push_back( entry );
	CFlow::Write( lpData, dwSize );
}
BOOL CRes::Write()
{
	_ASSERT( entries.size() );
	std::vector<HashEntry> new_entry;
	new_entry.resize( hdr.dwFilesCount );
	BuildHash( new_entry );

	CFlow::Write( &new_entry.front(), (DWORD)new_entry.size() * sizeof(HashEntry) );
	CFlow::Write( &files_names.front(), files_names.size() );
	
	CFlow::SetPosition( 0 );
	CFlow::Write( &hdr, sizeof(FileHeader) );
	return TRUE;
}
void CRes::BuildHash( std::vector<HashEntry> &new_entry )
{
	int nLastFreeIndex =  hdr.dwFilesCount - 1;

	for ( DWORD i = 0; i < hdr.dwFilesCount; i++ )
	{
		new_entry[i].dwNextIndex = -1;
		new_entry[i].dwFileOffset = 0;
	}

	for ( DWORD i = 0; i < hdr.dwFilesCount; i++ )
	{
		int nIndex = CalcHash( &files_names[entries[i].dwNameOffset], entries[i].wNameSize );

		if ( new_entry[nIndex].dwFileOffset )
		{
			while ( new_entry[nIndex].dwNextIndex != -1 )
				nIndex = new_entry[nIndex].dwNextIndex;

			int nFreeIndex = nLastFreeIndex;
			while ( new_entry[nFreeIndex].dwFileOffset )
				nFreeIndex--;

			new_entry[nIndex].dwNextIndex = nFreeIndex;
			nIndex = nFreeIndex;
		}
		new_entry[nIndex] = entries[i];
		new_entry[nIndex].dwNextIndex = -1;
	}
}


