#pragma once
#include "flow.h"


class CRes : public CFileFlow
{
	static const DWORD SIGNATURE = 0x19CE23C;
	/*  .res  */
	struct FileHeader
	{
		DWORD	dwSignature;			// :  27058748
		DWORD	dwFilesCount;			//     
		DWORD	dwOffsetTable;			//     
		DWORD	dwSizeNameTable;		//    .
	};

	#pragma pack(push,1)
	struct HashEntry
	{
		DWORD dwNextIndex;		//	3
		DWORD dwFileSize;		//  1
		DWORD dwFileOffset;		//  5
		long  utime;
		WORD  wNameSize;		//  4
		DWORD dwNameOffset;		//  2
	};
	#pragma pack()

protected:
	FileHeader hdr;
	std::vector<HashEntry> entries;
	std::vector<char> files_names;

public:
	CRes();
	virtual ~CRes(void);
	virtual void Close();
	virtual BOOL OpenRead( LPCSTR lpszFilePath );
	virtual BOOL OpenWrite( LPCSTR lpszFilePath );
	virtual BOOL GetFile( LPCSTR lpszFileName, class IFlow &file );

	// For res write 
	void AddFile( LPCSTR lpszFileName, LPCVOID lpData, DWORD dwSize );
	BOOL Write();

protected:
	virtual BOOL IsRes() { return TRUE; };
	virtual BOOL ReadHash();
	
private:	
	int FindFile( LPCSTR lpszFileName, int &dwIndex ) const;
	int CalcHash( LPCSTR lpszFileName, int nSize ) const;
	void BuildHash( std::vector<HashEntry> &new_entries );


};